/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebPolicyDecisionListener;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.MessageBox;

class WebPolicyDelegate {
    COMObject iWebPolicyDelegate;
    int refCount = 0;
    Browser browser;

    WebPolicyDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebPolicyDelegate = new COMObject(new int[]{2, 0, 0, 5, 5, 5, 3}){

            @Override
            public long method0(long[] args) {
                return WebPolicyDelegate.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return WebPolicyDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return WebPolicyDelegate.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return WebPolicyDelegate.this.decidePolicyForNavigationAction(args[0], args[1], args[2], args[3], args[4]);
            }

            @Override
            public long method4(long[] args) {
                return WebPolicyDelegate.this.decidePolicyForNewWindowAction(args[0], args[1], args[2], args[3], args[4]);
            }

            @Override
            public long method5(long[] args) {
                return WebPolicyDelegate.this.decidePolicyForMIMEType(args[0], args[1], args[2], args[3], args[4]);
            }

            @Override
            public long method6(long[] args) {
                return WebPolicyDelegate.this.unableToImplementPolicyWithError(args[0], args[1], args[2]);
            }
        };
    }

    int decidePolicyForMIMEType(long webView, long type, long request, long frame, long listener) {
        IWebView iwebView = new IWebView(webView);
        int[] canShow = new int[1];
        iwebView.canShowMIMEType(type, canShow);
        IWebPolicyDecisionListener pdListener = new IWebPolicyDecisionListener(listener);
        if (canShow[0] != 0) {
            pdListener.use();
        } else {
            pdListener.download();
        }
        return 0;
    }

    int decidePolicyForNavigationAction(long webView, long actionInformation, long request, long frame, long listener) {
        IWebURLRequest iwebUrlRequest = new IWebURLRequest(request);
        long[] result = new long[1];
        int hr = iwebUrlRequest.URL(result);
        if (hr != 0 || result[0] == 0L) {
            return 0;
        }
        String url = WebKit.extractBSTR(result[0]);
        COM.SysFreeString(result[0]);
        IWebPolicyDecisionListener pdListener = new IWebPolicyDecisionListener(listener);
        WebKit webKit = (WebKit)this.browser.webBrowser;
        if (webKit.loadingText) {
            pdListener.use();
            return 0;
        }
        if (url.length() == 0) {
            pdListener.ignore();
            return 0;
        }
        if (url.startsWith("file://") && webKit.getUrl().startsWith("about:blank") && webKit.untrustedText) {
            pdListener.ignore();
            return 0;
        }
        if (url.equals("file:///")) {
            url = "about:blank";
        } else {
            int length = "file:///".length();
            if (url.startsWith("file:///") && url.charAt(length) == '#') {
                url = "about:blank" + url.substring(length);
            }
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url;
        newEvent.doit = true;
        LocationListener[] locationListeners = webKit.locationListeners;
        if (locationListeners != null) {
            for (LocationListener locationListener : locationListeners) {
                locationListener.changing(newEvent);
            }
        }
        if (newEvent.doit) {
            if (webKit.jsEnabled != webKit.jsEnabledOnNextPage) {
                webKit.jsEnabled = webKit.jsEnabledOnNextPage;
                IWebView view = new IWebView(webView);
                result[0] = 0L;
                hr = view.preferences(result);
                if (hr == 0 && result[0] != 0L) {
                    IWebPreferences preferences = new IWebPreferences(result[0]);
                    hr = preferences.setJavaScriptEnabled(webKit.jsEnabled ? 1 : 0);
                    view.setPreferences(preferences.getAddress());
                    preferences.Release();
                }
            }
            pdListener.use();
            webKit.lastNavigateURL = url;
        } else {
            pdListener.ignore();
        }
        return 0;
    }

    int decidePolicyForNewWindowAction(long webView, long actionInformation, long request, long frameName, long listener) {
        IWebPolicyDecisionListener pdListener = new IWebPolicyDecisionListener(listener);
        pdListener.use();
        return 0;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebPolicyDelegate != null) {
            this.iWebPolicyDelegate.dispose();
            this.iWebPolicyDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebPolicyDelegate.getAddress();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebPolicyDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebPolicyDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebPolicyDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[]{0L}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int unableToImplementPolicyWithError(long webView, long error, long frame) {
        if (this.browser.isDisposed()) {
            return 0;
        }
        IWebError iweberror = new IWebError(error);
        String failingURL = null;
        long[] result = new long[1];
        int hr = iweberror.failingURL(result);
        if (hr == 0 && result[0] != 0L) {
            failingURL = WebKit.extractBSTR(result[0]);
            COM.SysFreeString(result[0]);
        }
        result[0] = 0L;
        hr = iweberror.localizedDescription(result);
        if (hr != 0 || result[0] == 0L) {
            return 0;
        }
        String description = WebKit.extractBSTR(result[0]);
        COM.SysFreeString(result[0]);
        String message = failingURL != null ? failingURL + "\n\n" : "";
        message = message + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{description});
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
        messageBox.setMessage(message);
        messageBox.open();
        return 0;
    }
}

