package org.dbgl.gui.controls;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;


public class ProgressBar_ {

	private final ProgressBar bar_;

	public ProgressBar_(Builder builder) {
		bar_ = new ProgressBar(builder.composite_, builder.style_);
		if (DarkTheme.forced()) {
			bar_.setBackground(DarkTheme.inputBackground);
		}
		bar_.setLayoutData(builder.layoutData());
		if ((builder.style_ & SWT.INDETERMINATE) != SWT.INDETERMINATE)
			bar_.setMaximum(builder.max_);
		if (builder.sel_ != Integer.MIN_VALUE)
			bar_.setSelection(builder.sel_);
	}

	public ProgressBar ctrl() {
		return bar_;
	}

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static final class Builder extends ControlBuilder<Builder> {
		private int sel_ = Integer.MIN_VALUE;
		private int max_ = 100;

		Builder(Composite composite) {
			super(composite, SWT.HORIZONTAL, SWT.FILL, SWT.CENTER, true, false);
		}

		public Builder indeterminate() {
			style_ |= SWT.INDETERMINATE;
			return this;
		}

		public Builder sel(int sel) {
			sel_ = sel;
			return this;
		}

		public Builder max(int max) {
			max_ = max;
			return this;
		}

		public ProgressBar_ build() {
			return new ProgressBar_(this);
		}

		public ProgressBar ctrl() {
			return build().ctrl();
		}
	}
}
