package org.dbgl.gui.controls;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;


public class Table_ {

	private final Table table_;

	public Table_(Builder builder) {
		table_ = new Table(builder.composite_, builder.style_);
		table_.setHeaderVisible(builder.header_);
		if (DarkTheme.forced()) {
			table_.setBackground(DarkTheme.inputBackground);
			table_.setForeground(DarkTheme.defaultForeground);
			table_.setHeaderBackground(DarkTheme.tableHeaderBackground);
			table_.setHeaderForeground(DarkTheme.tableHeaderForeground);
		}
		table_.setLayoutData(builder.layoutData());
		table_.setLinesVisible(!DarkTheme.forced());
	}

	public Table ctrl() {
		return table_;
	}

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static final class Builder extends ControlBuilder<Builder> {
		private boolean header_;

		Builder(Composite composite) {
			super(composite, SWT.BORDER | SWT.FULL_SELECTION, SWT.FILL, SWT.CENTER, true, false);
		}

		public Builder header() {
			header_ = true;
			return this;
		}

		public Builder multi() {
			style_ |= SWT.MULTI;
			return this;
		}

		public Builder check() {
			style_ |= SWT.CHECK;
			return this;
		}

		public Builder scroll() {
			style_ |= SWT.H_SCROLL;
			style_ |= SWT.V_SCROLL;
			verticalAlignment_ = SWT.FILL;
			grabExcessVerticalSpace_ = true;
			return this;
		}

		public Table_ build() {
			return new Table_(this);
		}

		public Table ctrl() {
			return build().ctrl();
		}
	}
}
