/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static long GTKCLIPBOARD = GTK.GTK4 ? GDK.gdk_display_get_clipboard(GDK.gdk_display_get_default()) : GTK3.gtk_clipboard_get(0L);
    static long GTKPRIMARYCLIPBOARD;
    private static long TARGET;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = Clipboard.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        proxy.clear(this, clipboards);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if (GTK.GTK4) {
            Object result = this.getContents_gtk4(transfer, clipboards);
            return result;
        }
        long selection_data = 0L;
        int[] typeIds = transfer.getTypeIds();
        for (int i = 0; i < typeIds.length; ++i) {
            if ((clipboards & 1) != 0) {
                selection_data = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, typeIds[i]);
            }
            if (selection_data != 0L) break;
            if ((clipboards & 2) == 0) continue;
            selection_data = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, typeIds[i]);
        }
        if (selection_data == 0L) {
            return null;
        }
        TransferData tdata = new TransferData();
        tdata.type = GTK3.gtk_selection_data_get_data_type(selection_data);
        tdata.pValue = GTK3.gtk_selection_data_get_data(selection_data);
        tdata.length = GTK3.gtk_selection_data_get_length(selection_data);
        tdata.format = GTK3.gtk_selection_data_get_format(selection_data);
        Object result = transfer.nativeToJava(tdata);
        GTK3.gtk_selection_data_free(selection_data);
        return result;
    }

    private Object getContents_gtk4(Transfer transfer, int clipboards) {
        long contents = GTK4.gdk_clipboard_get_content(GTKCLIPBOARD);
        if (contents == 0L) {
            return null;
        }
        long value = OS.g_malloc(OS.GValue_sizeof());
        C.memset(value, 0, OS.GValue_sizeof());
        if (transfer.getTypeNames()[0].equals("STRING") || transfer.getTypeNames()[0].equals("text/rtf")) {
            OS.g_value_init(value, OS.G_TYPE_STRING());
            if (!GTK4.gdk_content_provider_get_value(contents, value, null)) {
                return null;
            }
            long cStr = OS.g_value_get_string(value);
            long[] items_written = new long[1];
            long utf16Ptr = OS.g_utf8_to_utf16(cStr, -1L, null, items_written, null);
            OS.g_free(cStr);
            if (utf16Ptr == 0L) {
                return null;
            }
            int length = (int)items_written[0];
            char[] buffer = new char[length];
            C.memmove(buffer, utf16Ptr, (long)(length * 2));
            OS.g_free(utf16Ptr);
            String str = new String(buffer);
            if (transfer.getTypeNames()[0].equals("text/rtf") && !str.contains("{\\rtf1")) {
                return null;
            }
            if (transfer.getTypeNames()[0].equals("STRING") && str.contains("{\\rtf1")) {
                return null;
            }
            return str;
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null && dataTypes[i] != null && dataTypes[i].validate(data[i])) continue;
            DND.error(5);
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        if (!proxy.setData(this, data, dataTypes, clipboards)) {
            DND.error(2002);
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        int[] types;
        this.checkWidget();
        TransferData[] result = null;
        if ((clipboards & 1) != 0) {
            types = this.getAvailableClipboardTypes();
            result = new TransferData[types.length];
            for (int i = 0; i < types.length; ++i) {
                result[i] = new TransferData();
                result[i].type = types[i];
            }
        }
        if ((clipboards & 2) != 0) {
            types = this.getAvailablePrimaryTypes();
            int offset = 0;
            if (result != null) {
                TransferData[] newResult = new TransferData[result.length + types.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                offset = result.length;
                result = newResult;
            } else {
                result = new TransferData[types.length];
            }
            for (int i = 0; i < types.length; ++i) {
                result[offset + i] = new TransferData();
                result[offset + i].type = types[i];
            }
        }
        return result == null ? new TransferData[]{} : result;
    }

    public String[] getAvailableTypeNames() {
        byte[] buffer;
        long pName;
        int i;
        this.checkWidget();
        int[] types1 = this.getAvailableClipboardTypes();
        int[] types2 = this.getAvailablePrimaryTypes();
        String[] result = new String[types1.length + types2.length];
        int count = 0;
        for (i = 0; i < types1.length; ++i) {
            pName = GDK.gdk_atom_name(types1[i]);
            if (pName == 0L) continue;
            buffer = new byte[C.strlen(pName)];
            C.memmove(buffer, pName, (long)buffer.length);
            OS.g_free(pName);
            result[count++] = "GTKCLIPBOARD " + new String(Converter.mbcsToWcs(buffer));
        }
        for (i = 0; i < types2.length; ++i) {
            pName = GDK.gdk_atom_name(types2[i]);
            if (pName == 0L) continue;
            buffer = new byte[C.strlen(pName)];
            C.memmove(buffer, pName, (long)buffer.length);
            OS.g_free(pName);
            result[count++] = "GTKPRIMARYCLIPBOARD " + new String(Converter.mbcsToWcs(buffer));
        }
        if (count < result.length) {
            String[] temp = new String[count];
            System.arraycopy(result, 0, temp, 0, count);
            result = temp;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getAvailablePrimaryTypes() {
        int[] types = new int[]{};
        long selection_data = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, TARGET);
        if (selection_data != 0L) {
            try {
                int length = GTK3.gtk_selection_data_get_length(selection_data);
                int format = GTK3.gtk_selection_data_get_format(selection_data);
                long data = GTK3.gtk_selection_data_get_data(selection_data);
                if (length != 0) {
                    types = new int[length * 8 / format];
                    C.memmove(types, data, (long)length);
                }
            }
            finally {
                GTK3.gtk_selection_data_free(selection_data);
            }
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getAvailableClipboardTypes() {
        if (GTK.GTK4) {
            // empty if block
        }
        int[] types = new int[]{};
        long selection_data = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, TARGET);
        if (selection_data != 0L) {
            try {
                int length = GTK3.gtk_selection_data_get_length(selection_data);
                int format = GTK3.gtk_selection_data_get_format(selection_data);
                long data = GTK3.gtk_selection_data_get_data(selection_data);
                if (length != 0) {
                    types = new int[length * 8 / format];
                    C.memmove(types, data, (long)length);
                }
            }
            finally {
                GTK3.gtk_selection_data_free(selection_data);
            }
        }
        return types;
    }

    long gtk_clipboard_wait_for_contents(long clipboard, long target) {
        long startTime = System.currentTimeMillis();
        String key = "org.eclipse.swt.internal.gtk.dispatchEvent";
        Display display = this.display;
        display.setData(key, new int[]{16, 17, 18, 19});
        long selection_data = GTK3.gtk_clipboard_wait_for_contents(clipboard, target);
        display.setData(key, null);
        long duration = System.currentTimeMillis() - startTime;
        if (selection_data == 0L && duration > 5000L) {
            ClipboardProxy._getInstance(display).setData(this, new String[]{" "}, new Transfer[]{TextTransfer.getInstance()}, clipboard == GTKCLIPBOARD ? 1 : 2);
        }
        return selection_data;
    }

    static {
        byte[] buffer = Converter.wcsToMbcs("PRIMARY", true);
        long primary = GTK.GTK4 ? 0L : GDK.gdk_atom_intern(buffer, false);
        GTKPRIMARYCLIPBOARD = GTK.GTK4 ? GDK.gdk_display_get_primary_clipboard(GDK.gdk_display_get_default()) : GTK3.gtk_clipboard_get(primary);
        buffer = Converter.wcsToMbcs("TARGETS", true);
        TARGET = GTK.GTK4 ? 0L : GDK.gdk_atom_intern(buffer, false);
    }
}

