/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static char[] mbcsToWcs(byte[] buffer) {
        long[] items_written = new long[1];
        long ptr = OS.g_utf8_to_utf16(buffer, (long)buffer.length, null, items_written, null);
        if (ptr == 0L) {
            return EmptyCharArray;
        }
        int length = (int)items_written[0];
        char[] chars = new char[length];
        C.memmove(chars, ptr, (long)(length * 2));
        OS.g_free(ptr);
        return chars;
    }

    public static byte[] wcsToMbcs(String string, boolean terminate) {
        int length = string.length();
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        return Converter.wcsToMbcs(buffer, terminate);
    }

    public static byte[] javaStringToCString(String string) {
        return Converter.wcsToMbcs(string, true);
    }

    public static String cCharPtrToJavaString(long cCharPtr, boolean freecCharPtr) {
        int length = C.strlen(cCharPtr);
        byte[] buffer = new byte[length];
        C.memmove(buffer, cCharPtr, (long)length);
        if (freecCharPtr) {
            OS.g_free(cCharPtr);
        }
        return new String(Converter.mbcsToWcs(buffer));
    }

    public static byte[] wcsToMbcs(char[] chars, boolean terminate) {
        long[] items_read = new long[1];
        long[] items_written = new long[1];
        long ptr = OS.g_utf16_to_utf8(chars, chars.length, items_read, items_written, null);
        if (ptr == 0L) {
            return terminate ? NullByteArray : EmptyByteArray;
        }
        int written = (int)items_written[0];
        byte[] bytes = new byte[written + (terminate ? 1 : 0)];
        C.memmove(bytes, ptr, (long)written);
        OS.g_free(ptr);
        return bytes;
    }

    public static char wcsToMbcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = Converter.wcsToMbcs(new char[]{ch}, false);
        if (buffer.length == 1) {
            return (char)buffer[0];
        }
        if (buffer.length == 2) {
            return (char)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
        }
        return '\u0000';
    }

    public static char mbcsToWcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = key <= 255 ? new byte[]{(byte)key} : new byte[]{(byte)(key >> 8 & 0xFF), (byte)(key & 0xFF)};
        char[] result = Converter.mbcsToWcs(buffer);
        if (result.length == 0) {
            return '\u0000';
        }
        return result[0];
    }

    public static String byteToStringViaHeuristic(byte[] bytes) {
        if (bytes.length == 0 || bytes.length == 1 && bytes[0] == 0) {
            return "";
        }
        try {
            CharsetDecoder charDecoder = StandardCharsets.UTF_8.newDecoder();
            charDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            String text = charDecoder.decode(ByteBuffer.wrap(bytes)).toString();
            boolean probablyUTF8 = true;
            double nullBytePercentageForUtf16 = 0.01;
            int nullCount = 0;
            for (byte b : bytes) {
                if (b != 0) continue;
                ++nullCount;
            }
            double nullPercentage = (double)nullCount / (double)bytes.length;
            if (nullPercentage > nullBytePercentageForUtf16) {
                probablyUTF8 = false;
            }
            if (probablyUTF8) {
                char[] chars = text.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    int codePoint = Character.codePointAt(chars, i);
                    if (Character.isValidCodePoint(codePoint)) continue;
                    probablyUTF8 = false;
                    break;
                }
            }
            if (!probablyUTF8) {
                return new String(bytes, StandardCharsets.UTF_16LE);
            }
            return text;
        }
        catch (CharacterCodingException charDecoder) {
            Charset[] commonWebCharSets;
            for (Charset setToTry : commonWebCharSets = new Charset[]{StandardCharsets.UTF_16LE, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16}) {
                try {
                    CharsetDecoder charDecoder2 = setToTry.newDecoder();
                    charDecoder2.onMalformedInput(CodingErrorAction.REPORT);
                    charDecoder2.onUnmappableCharacter(CodingErrorAction.REPORT);
                    return charDecoder2.decode(ByteBuffer.wrap(bytes)).toString();
                }
                catch (CharacterCodingException characterCodingException) {
                }
            }
            StringWriter sw = new StringWriter();
            new Throwable("").printStackTrace(new PrintWriter(sw));
            return "SWT: Failed to decode byte buffer. Encoding is not ASCII/UTF-8/UTF-16[LE|BE|BOM]/ISO_8859_1. Stack trace:\n" + sw.toString();
        }
    }
}

