/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SwtCallable;
import org.eclipse.swt.SwtRunnable;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BusyIndicator {
    private static final AtomicInteger nextBusyId = new AtomicInteger();
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";

    public static void showWhile(Display display, Runnable runnable) {
        if (runnable == null) {
            SWT.error(4);
        }
        if (display == null && (display = Display.getCurrent()) == null) {
            runnable.run();
            return;
        }
        Integer busyId = BusyIndicator.setBusyCursor(display);
        try {
            runnable.run();
        }
        finally {
            BusyIndicator.clearBusyCursor(display, busyId);
        }
    }

    public static <E extends Exception> CompletableFuture<?> execute(SwtRunnable<E> action) {
        return BusyIndicator.execute(action, ForkJoinPool.commonPool());
    }

    public static <E extends Exception> CompletableFuture<?> execute(SwtRunnable<E> action, Executor executor) {
        return BusyIndicator.compute(() -> {
            action.run();
            return null;
        }, executor);
    }

    public static <V, E extends Exception> CompletableFuture<V> compute(SwtCallable<V, E> action) {
        return BusyIndicator.compute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> CompletableFuture<V> compute(SwtCallable<V, E> action, Executor executor) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        if (executor instanceof Display) {
            throw new IllegalArgumentException("passing a Display as an executor is not allowed!");
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null) {
            try {
                V inplaceResult = action.call();
                return CompletableFuture.completedFuture(inplaceResult);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        Integer busyId = BusyIndicator.setBusyCursor(display);
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                if (future.isCancelled()) {
                    return;
                }
                Object asyncResult = action.call();
                future.complete(asyncResult);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            finally {
                display.asyncExec(() -> BusyIndicator.clearBusyCursor(display, busyId));
            }
        });
        return future;
    }

    private static void clearBusyCursor(Display display, Integer busyId) {
        Shell[] shells;
        for (Shell shell : shells = display.getShells()) {
            Integer id2 = (Integer)shell.getData(BUSYID_NAME);
            if (!Objects.equals(id2, busyId)) continue;
            BusyIndicator.setCursorAndId(shell, null, null);
        }
    }

    private static Integer setBusyCursor(Display display) {
        Shell[] shells;
        Integer busyId = nextBusyId.getAndIncrement();
        Cursor cursor = display.getSystemCursor(1);
        for (Shell shell : shells = display.getShells()) {
            Integer id2 = (Integer)shell.getData(BUSYID_NAME);
            if (id2 != null) continue;
            BusyIndicator.setCursorAndId(shell, cursor, busyId);
        }
        return busyId;
    }

    private static void setCursorAndId(Shell shell, Cursor cursor, Integer busyId) {
        if (!shell.isDisposed()) {
            shell.setCursor(cursor);
        }
        if (!shell.isDisposed()) {
            shell.setData(BUSYID_NAME, busyId);
        }
    }
}

