/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String ID_NAME = OS.NSFilenamesPboardType.getString();
    static final int ID = FileTransfer.registerType(ID_NAME);
    static final String ID1_NAME = OS.kUTTypeFileURL.getString();
    static final int ID1 = FileTransfer.registerType(ID1_NAME);

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] files = (String[])object;
        int length = files.length;
        NSMutableArray array = NSMutableArray.arrayWithCapacity(length);
        for (int i = 0; i < length; ++i) {
            String fileName = files[i];
            NSString string = NSString.stringWith(fileName);
            array.addObject(string);
        }
        transferData.data = array;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSArray array = (NSArray)transferData.data;
        if (array.count() == 0L) {
            return null;
        }
        int count = (int)array.count();
        String[] fileNames = new String[count];
        for (int i = 0; i < count; ++i) {
            NSString string = new NSString(array.objectAtIndex(i));
            fileNames[i] = string.getString();
        }
        return fileNames;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{ID, ID1};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{ID_NAME, ID1_NAME};
    }

    boolean checkFile(Object object) {
        String[] strings;
        block4: {
            block3: {
                if (object == null || !(object instanceof String[])) break block3;
                strings = (String[])object;
                if (((String[])object).length != 0) break block4;
            }
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] != null && strings[i].length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

