/*
 *  Copyright (C) 2006-2024  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui.controls;

import org.apache.commons.lang3.StringUtils;


public class SingleValueDaControlConvertor extends BaseDaControlConvertor {

	private SingleValueDaControlConvertor() {}
	
	private static class SingleValueDaControlConvertorHolder {
		private static final SingleValueDaControlConvertor instance_ = new SingleValueDaControlConvertor();
	}

	public static SingleValueDaControlConvertor getInstance() {
		return SingleValueDaControlConvertorHolder.instance_;
	}

	@Override
	public String toConfValue(String existingValue, String[] values) {
		String joinedValues = String.join(StringUtils.EMPTY, values);
		if (StringUtils.isBlank(existingValue))
			return joinedValues;

		String[] exVals = toControlValues(existingValue);
		if (exVals.length != values.length) {
			System.err.println("configuration values mismatch: [" + existingValue + "] vs. [" + joinedValues + "]");
			return existingValue;
		}

		return values[0];
	}

	@Override
	public String toConfValueForDisplay(String[] values) {
		return StringUtils.defaultIfBlank(toConfValue(null, values), "...");
	}
	
	@Override
	public String[] toControlValues(String value) {
		return value == null ? new String[0]: new String[] {value};
	}
}